
// Includes ====================================================================
#include <example.hpp>
#include <boost/python.hpp>
#include <boost/python/suite/indexing/vector_indexing_suite.hpp>

// Using =======================================================================
using namespace boost::python;

// Declarations ================================================================
namespace  {

struct Vortex_Wrapper: Vortex
{
    Vortex_Wrapper(PyObject* self_, const Vortex& p0):
        Vortex(p0), self(self_) {}

    Vortex_Wrapper(PyObject* self_, const complex<double>& p0):
        Vortex(p0), self(self_) {}

    Vortex_Wrapper(PyObject* self_, const complex<double>& p0, const double p1):
        Vortex(p0, p1), self(self_) {}

    complex<double> velocity(const complex<double>& p0) const {
        return call_method< complex<double> >(self, "velocity", p0);
    }

    PyObject* self;
};

struct PointVortex_Wrapper: PointVortex
{
    PointVortex_Wrapper(PyObject* self_, const PointVortex& p0):
        PointVortex(p0), self(self_) {}

    PointVortex_Wrapper(PyObject* self_, const complex<double>& p0):
        PointVortex(p0), self(self_) {}

    PointVortex_Wrapper(PyObject* self_, const complex<double>& p0, const double p1):
        PointVortex(p0, p1), self(self_) {}

    complex<double> velocity(const complex<double>& p0) const {
        return call_method< complex<double> >(self, "velocity", p0);
    }

    complex<double> default_velocity(const complex<double>& p0) const {
        return PointVortex::velocity(p0);
    }

    PyObject* self;
};


object mO_wrapper(const int i, double a, double b)
{
    int ret = multipleOutput(i, a, b);
    return make_tuple(ret, a, b);
}


}// namespace 


// Module ======================================================================
BOOST_PYTHON_MODULE(example)
{
    class_< Vortex, boost::noncopyable, Vortex_Wrapper >("Vortex", init< const complex<double>&, optional< const double > >())
        .def("velocity", pure_virtual(&Vortex::velocity))
        .def("position", &Vortex::position)
        .def("myVelocity", &Vortex::myVelocity)
        .def("strength", &Vortex::strength)
        .def("setStrength", &Vortex::setStrength)
        .def("setPosition", &Vortex::setPosition)
        .def("setVelocity", &Vortex::setVelocity)
        .def("addVelocity", &Vortex::addVelocity)
    ;

    class_< PointVortex, bases< Vortex > , PointVortex_Wrapper >("PointVortex", init< const PointVortex& >())
        .def(init< const complex<double>&, optional< const double > >())
        .def("velocity", (complex<double> (PointVortex::*)(const complex<double>&) const)&PointVortex::velocity, (complex<double> (PointVortex_Wrapper::*)(const complex<double>&) const)&PointVortex_Wrapper::default_velocity)
    ;

    def("computeVelocity", &computeVelocity);
    def("multipleOutput", &mO_wrapper);
    class_<std::vector<Vortex*> > ("VectorVortex")
        .def(vector_indexing_suite<std::vector<Vortex*> > ());

}

