#include <iostream>
#include <vector>
#include <complex>

class Vortex {
public:
    Vortex(const std::complex<double> &pos, const double str=1.0) 
        : m_z(pos), m_s(str)
    { m_v = std::complex<double> (0.0, 0.0); }
    virtual ~Vortex() 
    {}

    std::complex<double> position() const
    { return m_z; }
    std::complex<double> myVelocity() const
    { return m_v; }
    double strength() const
    { return m_s; }
    
    void setStrength(const double str)
    { m_s = str; }
    void setPosition(const std::complex<double> &pos)
    { m_z = pos; }
    void setVelocity(const std::complex<double> &v)
    { m_v = v; }
    void addVelocity(const std::complex<double> &v)
    { m_v += v; }
    
    virtual std::complex<double> 
    velocity(const std::complex<double> &pos) const = 0;

protected:
    std::complex<double> m_z, m_v;
    double m_s;
};

class PointVortex : public Vortex {
public:
    PointVortex(const std::complex<double> &pos, const double str=1.0) : 
        Vortex(pos, str)
    {}

    virtual std::complex<double> 
    velocity(const std::complex<double> &pos) const
    {
        if (pos != m_z)
            return -0.5*m_s/M_PI*(pos - m_z);
        else
            return std::complex<double>(0.0, 0.0);
    }
};

void computeVelocity(std::vector<Vortex*> &arr)
{
    for (std::size_t i=0; i<arr.size(); ++i) {
        arr[i]->setVelocity(std::complex<double>(0.0, 0.0));
    }

    Vortex *v1;
    Vortex *v2;
    for (std::size_t i=0; i<arr.size(); ++i) {
        v1 = arr[i];
        for (std::size_t j=0; j<arr.size(); ++j) {
            v2 = arr[j];
            v1->addVelocity(v2->velocity(v1->position()));
        }
    }
}

int multipleOutput(const int i, double &a, double &b)
{
    a += i;
    b += i;
    return i;
}
