#include "example.hpp"
#include <cstdlib>
#include <time.h>
#define NV 2000

inline double seconds()
{
    static const double secs_per_tick = 1.0 / CLOCKS_PER_SEC;
    return ( (double) clock() ) * secs_per_tick;
}

double rnd ()
{
    return static_cast<double>(random())/RAND_MAX;
}

std::complex<double> randz(const double rad=1.0)
{
    return rad*std::complex<double>(rnd(), rnd());
}

void initVortex(std::vector<Vortex*> &v)
{
    srand(5973);
    std::complex<double> z;
    for (std::size_t i=0; i<NV; ++i) {
        v.push_back(new PointVortex(randz(), 1.0));
    }
}

int main(int argc, char * argv[])
{
    std::vector<Vortex*> v;
    double t1 = seconds();
    initVortex(v);
    t1 = seconds() - t1;
    std::cout << "Time taken to initialize " << NV 
              << " particles = " << t1 << "\n";
    t1 = seconds();
    computeVelocity(v);
    t1 = seconds() - t1;
    std::cout << "Time taken for computeVelocity = "
              << t1 << "\n";
    /*std::cout << "v[0] = " << v[0]->myVelocity() 
      << "; v[-1] = " << v.back()->myVelocity() << std::endl;*/
    return 0;
}
