import example
import random
import time
from math import pi

def getComplex():
    return random.random() + random.random()*1j

class MyBlob(example.PointVortex):
    def __init__(self, pos, str):
        example.PointVortex.__init__(self, pos, str)
    def velocity(self, pos):
        return -example.PointVortex.velocity(self, pos)


def initVortex(a, n=2000, elem=example.PointVortex):
    random.seed(1)
    for i in xrange(n):
        a.append(elem(getComplex(), 1.0))

def computeVelocity(arr):
    for i in arr:
        i.setVelocity(0.0);

    for v1 in arr:
        for v2 in arr:
            v1.addVelocity(v2.velocity(v1.position()))

def main(elem=example.PointVortex):
    a = []
    t1 = time.clock()
    initVortex(a, 300, elem)
    av = example.VectorVortex()
    av[:] = a
    t1 = time.clock() - t1
    print "Time taken to initialize particle =", t1

    t1 = time.clock()
    example.computeVelocity(av)
    t1 = time.clock() - t1
    print "Time taken for example.computeVelocity =", t1
    print "v[0].myVelocity() =", a[0].myVelocity()
    print "v[-1].myVelocity() =", a[-1].myVelocity()

    if len(av) < 400:
        t1 = time.clock()
        computeVelocity(a)
        t1 = time.clock() - t1
        print "Time taken for computeVelocity =", t1
        print "v[0].myVelocity() =", a[0].myVelocity()
        print "v[-1].myVelocity() =", a[-1].myVelocity()
        
    
if __name__ == "__main__":
    main()
    main(elem=MyBlob)
    
